/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.converter.sys;

import java.io.Serializable;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ext.Selectable;

public abstract class AbstractSelectedIndexConverter<C extends Component>
implements Converter<Object, Object, C>,
Serializable {
    private static final long serialVersionUID = 201108171811L;

    @Override
    public Object coerceToUi(Object val, C comp, BindContext ctx) {
        ListModel<?> model = this.getComponentModel(comp);
        if (model != null && !(model instanceof Selectable)) {
            throw new UiException("model doesn't implement Selectable");
        }
        if (val != null) {
            if (model != null) {
                int index = (Integer)val;
                if (index < 0) {
                    Set sels = ((Selectable)model).getSelection();
                    if (sels != null && sels.size() > 0) {
                        ((Selectable)model).clearSelection();
                    }
                } else {
                    ((Selectable)model).addToSelection(model.getElementAt(index));
                }
                return IGNORED_VALUE;
            }
            return val;
        }
        if (model != null) {
            Set sels = ((Selectable)model).getSelection();
            if (sels != null && sels.size() > 0) {
                ((Selectable)model).clearSelection();
            }
            return IGNORED_VALUE;
        }
        return val;
    }

    protected abstract ListModel<?> getComponentModel(C var1);

    @Override
    public Object coerceToBean(Object val, C comp, BindContext ctx) {
        return val;
    }
}

